## Linux系统下安装方式
- **首先查看系统中是否已安装JDK**
> [root@VM-12-6-centos software]# java -version

显示如下：
> openjdk version "1.8.0_102"
> OpenJDK Runtime Environment(build 1.8.0_102-b14)
> OpenJDK 64-Bit Server VM(build 25.102-b14, mixed mode)


- **卸载已安装的**

首先检测安装包：
> [root@VM-12-6-centos software]# rpm -qa | grep java

显示如下：
> java-1.7.0-openjdk-1.7.0.111-2.6.7.8.el7.x86_64
> python-javapackages-3.4.1-11.el7.noarch
> tzdata-java-2016g-2.el7.noarch
> javapackages-tools-3.4.1-11.el7.noarch
> java-1.8.0-openjdk-1.8.0.102-4.b14.el7.x86_64
> java-1.8.0-openjdk-headless-1.8.0.102-4.b14.el7.x86_64
> java-1.7.0-openjdk-headless-1.7.0.111-2.6.7.8.el7.x86_64

卸载：
> [root@VM-12-6-centos software]# rpm -e --nodeps tzdata-java-2016g-2.el7.noarch
> [root@VM-12-6-centos software]# rpm -e --nodeps java-1.7.0-openjdk-1.7.0.111- 2.6.7.8.el7.x86_64
> [root@VM-12-6-centos software]# rpm -e --nodeps java-1.7.0-openjdk-headless-1.7.0.111-2.6.7.8.el7.x86_64
> [root@VM-12-6-centos software]# rpm -e --nodeps java-1.8.0-openjdk-1.8.0.102-4.b14.el7.x86_64
> [root@VM-12-6-centos software]# rpm -e --nodeps java-1.8.0-openjdk-headless-1.8.0.102-4.b14.el7.x86_64

之后再次输入rpm -qa | grep java 查看卸载情况：
> [root@VM-12-6-centos software]# rpm -qa | grep java
> python-javapackages-3.4.1-11.el7.noarch
> javapackages-tools-3.4.1-11.el7.noarch


- **安装JDK**

首先到官网下载需要的JDK版本，也可以从[公司软件库](https://www.baidu.com)下载，在此省略此步骤
将jdk包上传到系统中指定的目录 **/opt/software** 下
创建JDK存放目录：
> [root@VM-12-6-centos local]# mkdir /usr/local/java

进入安装包目录：
> [root@VM-12-6-centos local]# cd /opt/software

 解压jdk-8u161-linux-x64.tar.gz安装包到指定目录：
> [root@VM-12-6-centos software]# tar -zxvf jdk-8u161-linux-x64.tar.gz -C /usr/local/java

设置环境变量：
> [root@VM-12-6-centos java]# vim /etc/profile

在最后面添加：
> export JAVA_HOME=/usr/local/java/jdk1.8.0_161
> export JRE_HOME=${JAVA_HOME}/jre
> export CLASSPATH=.:${JAVA_HOME}/lib:${JRE_HOME}/lib
> export PATH=${JAVA_HOME}/bin:$PATH

记得保存噢! (1.使用vim编辑好文件后，按下esc键退出编辑状态; 2.输入冒号+wq字符，按下回车.)
执行profile文件：
> [root@VM-12-6-centos java]# source /etc/profile

 这样可以使配置文件立即生效

- **检测JDK是否安装成功**

执行命令：
> [root@VM-12-6-centos java]# java -version

出现以下结果则JDK安装成功：
> java version "1.8.0_161"
> Java(TM) SE Runtime Environment (build 1.8.0_161-b12)
> Java HotSpot(TM) 64-Bit Server VM (build 25.161-b12, mixed mode)

至此，JDK安装结束。


